package examples.session.stateless;

import javax.naming.Context;
import javax.naming.InitialContext;

/**
 * This class is an example of client code which invokes
 * methods on a simple, remote stateless session bean.
 */
public class HelloClient {

	public static void main(String[] args) throws Exception {
		/*
		 * Obtain the JNDI initial context.
		 *
		 * The initial context is a starting point for
		 * connecting to a JNDI tree. We choose our JNDI
		 * driver, the network location of the server, etc
		 * by passing in the environment properties.
		 */
		Context ctx = new InitialContext(System.getProperties());

		/*
		 * Get a reference to a bean instance, looked up by class name
		 */
		Hello hello = (Hello) ctx.lookup(Hello.class.getName());

		/*
		 * Call the hello() method on the bean.
		 * We then print the result to the screen.
		 */
		System.out.println(hello.hello());

	}
}
